Attribute VB_Name = "modTimezone"
Option Explicit

Public Function TimeZoneBias() As String
    Dim oTZI As TIME_ZONE_INFORMATION, TimeZone As String
    Dim DLSDate As String, STDDate As String, Bias As Long
    On Error GoTo hErr
    GetTimeZoneInformation oTZI
    DLSDate = oTZI.DaylightDate.wMonth & "/" & oTZI.DaylightDate.wDay & "/" & Year(Date) & " " & oTZI.DaylightDate.wHour & ":" & oTZI.DaylightDate.wMinute & ":" & oTZI.DaylightDate.wSecond
    STDDate = oTZI.StandardDate.wMonth & "/" & oTZI.StandardDate.wDay & "/" & Year(Date) & " " & oTZI.StandardDate.wHour & ":" & oTZI.StandardDate.wMinute & ":" & oTZI.StandardDate.wSecond
    If oTZI.DaylightDate.wMonth = 0 Then
        Bias = oTZI.Bias - oTZI.StandardBias
        GoTo SkipDST
    End If
    If DateDiff("s", Now, DLSDate) >= 0 Then
        If DateDiff("s", Now, STDDate) <= 0 Then
            Bias = oTZI.Bias - oTZI.DaylightBias
        Else
            Bias = oTZI.Bias - oTZI.StandardBias
        End If
    Else
        Bias = oTZI.Bias - oTZI.StandardBias
    End If
SkipDST:
    TimeZoneBias = Bias
    Exit Function
hErr:
    ErrorHandler "TimeZone", "TimeZoneBias"
End Function
